/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskPropertyPanel;
import filenet.vw.apps.taskman.VWTaskTabbedPane;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.pa.PADataFieldCubesPanel;
import filenet.vw.apps.taskman.pa.PADataFieldGeneralPanel;
import filenet.vw.apps.taskman.pa.PADataFieldNode;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PADataFieldPropertyPanel
extends VWTaskPropertyPanel {
    PADataFieldNode m_node = null;
    VWTaskTabbedPane m_tabbedPane = null;
    PADataFieldGeneralPanel m_generalPanel = null;
    PADataFieldCubesPanel m_cubesPanel = null;
    private static int m_selectedTab = 0;

    public PADataFieldPropertyPanel(PADataFieldNode node) throws Exception {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.m_node = node;
        this.rebuildLayout();
    }

    protected void rebuildLayout() {
        this.removeAll();
        this.initLayout();
        this.refresh();
    }

    public void refresh() {
        try {
            if (!this.m_node.isDirty()) {
                this.resetProperties();
            }
        }
        catch (Exception e) {
            VWTaskCore.getInstance().displayError(e);
        }
    }

    protected void updateSelectedTab() {
        this.m_tabbedPane.setSelectedIndex(m_selectedTab);
    }

    private void initLayout() {
        this.m_tabbedPane = new VWTaskTabbedPane();
        VWTaskUtil.updateComponentOrientation(this.m_tabbedPane);
        this.m_generalPanel = new PADataFieldGeneralPanel(this.m_node);
        this.m_tabbedPane.addTab(VWResource.General, this.m_generalPanel);
        this.m_cubesPanel = new PADataFieldCubesPanel(this.m_node);
        this.m_tabbedPane.addTab(this.m_node.isExposedToFactTablesOnly() ? VWResource.FactTables : VWResource.Cubes, this.m_cubesPanel);
        this.m_tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                m_selectedTab = PADataFieldPropertyPanel.this.m_tabbedPane.getSelectedIndex();
            }
        });
        this.add((Component)this.m_tabbedPane, "Center");
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        Object aObj = event.getSource();
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.APPLY) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.OK) == 0) {
                this.validateProperties();
                this.applyProperties();
                this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 1));
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.RESET) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.CANCEL) == 0) {
                this.resetProperties();
                this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 2));
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.m_node.displayHelp();
            }
        }
        catch (Exception ex) {
            VWTaskCore.getInstance().displayError(ex);
        }
    }

    public void applyProperties() throws Exception {
    }

    public void resetProperties() throws Exception {
        this.m_generalPanel.resetProperties();
        this.m_cubesPanel.resetProperties();
    }

    private void validateProperties() throws Exception {
        this.m_tabbedPane.validateProperties();
    }
}

